/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.lock;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.lock.GroupLock;
import com.ibm.hsc.lock.Lockable;
import com.ibm.hsc.lock.RequestItem;
import com.ibm.hsc.lock.RequestQueue;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;

public class Lock
implements Lockable {
    Lock mParent;
    String mSectionId;
    Hashtable mChildHash;
    private static Lock NullLock = new Lock(null, "");
    static final int ST_FAILED = -1;
    static final int ST_WAITING = 0;
    static final int ST_READY = 1;
    static final int ST_RUNNING = 2;
    static final int ST_PENDING = 3;
    public static final int LT_NOLOCK = -1;
    public static final int LT_READ = 0;
    public static final int LT_WRITE = 1;
    public static final int LT_GREAD = 2;
    public static final int LT_GWRITE = 3;
    public static final int LT_EWRITE = 4;
    public static final int RS_FAILED = -1;
    public static final int RS_INVALID = 0;
    public static final int RS_GOTLOCK = 1;
    public static final int RS_INQUEUE = 2;
    public static boolean debug = false;
    static /* synthetic */ Class class$com$ibm$hsc$lock$RequestQueue;

    private Lock(Lock lock, String string) {
        this.mParent = lock;
        this.mSectionId = lock == null ? "" : string;
        this.mChildHash = new Hashtable();
    }

    public static Lock getNullLock() {
        return NullLock;
    }

    public static synchronized Lock getInstance(Lock lock, String string) {
        if (lock == null) {
            return NullLock;
        }
        if (string == null) {
            return lock;
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return lock;
        }
        Lock lock2 = (Lock)lock.mChildHash.get(string2);
        if (lock2 == null) {
            lock2 = new Lock(lock, string);
            lock.mChildHash.put(string, lock2);
        }
        return lock2;
    }

    public static synchronized Lock getInstance(String[] stringArray) {
        String string;
        if (stringArray == null) {
            return NullLock;
        }
        Lock lock = NullLock;
        for (int i = 0; i < stringArray.length && stringArray[i] != null && !(string = stringArray[i].trim()).equals(""); ++i) {
            lock = Lock.getInstance(lock, stringArray[i]);
        }
        return lock;
    }

    public static synchronized Lock getInstance(String string) {
        if (string == null) {
            return NullLock;
        }
        Lock lock = NullLock;
        String string2 = string.trim();
        if (!string2.equals("")) {
            lock = Lock.getInstance(NullLock, string2);
        }
        return lock;
    }

    public static synchronized Lock getInstance(String string, String string2) {
        if (string == null) {
            return NullLock;
        }
        Lock lock = NullLock;
        String string3 = string.trim();
        if (!string3.equals("")) {
            lock = Lock.getInstance(NullLock, string3);
            String string4 = string2.trim();
            if (!string4.equals("")) {
                lock = Lock.getInstance(lock, string4);
            }
        }
        return lock;
    }

    public static synchronized Lock getInstance(String string, String string2, String string3) {
        if (string == null) {
            return NullLock;
        }
        Lock lock = NullLock;
        String string4 = string.trim();
        if (!string4.equals("")) {
            lock = Lock.getInstance(NullLock, string4);
            String string5 = string2.trim();
            if (!string5.equals("")) {
                lock = Lock.getInstance(lock, string5);
                String string6 = string3.trim();
                if (!string6.equals("")) {
                    lock = Lock.getInstance(lock, string6);
                }
            }
        }
        return lock;
    }

    public String getSectionId() {
        return this.mSectionId;
    }

    public Vector getSectionIds() {
        Vector<String> vector = new Vector<String>();
        Lock lock = this;
        while (lock != NullLock) {
            String string = lock.getSectionId();
            vector.insertElementAt(string, 0);
            lock = lock.mParent;
        }
        return vector;
    }

    public String getTopSectionId() {
        Vector vector = this.getSectionIds();
        if (this == NullLock) {
            return "";
        }
        return (String)vector.elementAt(0);
    }

    public String toString() {
        return this.getSectionIds().toString();
    }

    public Lock getParentLock() {
        return this.mParent;
    }

    public boolean isDescendant(Lock lock) {
        Vector vector = this.getSectionIds();
        Vector vector2 = lock.getSectionIds();
        int n = vector2.size();
        if (vector.size() <= n) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (vector.elementAt(i).equals(vector2.elementAt(i))) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean related(Lock lock) {
        return this == lock || this.isDescendant(lock) || lock.isDescendant(this);
    }

    public RequestQueue getRequestQueue() {
        return RequestQueue.getRequestQueue(this);
    }

    public int lock(int n) throws PIHscServerException {
        return this.lock(n, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lock(int n, long l) throws PIHscServerException {
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = Lock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            Thread thread = Thread.currentThread();
            if (this == NullLock) {
                throw new PIHscServerException("3200");
            }
            if (n < 0 || n > 4) {
                System.out.println("Lock: Invalid lock type " + n + " " + this);
                throw new PIHscServerException("3201");
            }
            RequestQueue requestQueue = RequestQueue.getRequestQueue(this);
            if (debug) {
                System.out.println(requestQueue.toString());
            }
            if (n == 1 && requestQueue.hasPendingRequest(this)) {
                System.out.println("Lock: lock busy " + this);
                throw new PIHscServerException("3205");
            }
            try {
                RequestItem requestItem = requestQueue.get(thread, this);
                if (requestItem == null) {
                    requestItem = new RequestItem(thread, this, n);
                } else {
                    if (requestItem.getLock().related(this)) {
                        System.out.println("Lock: Existing Lock " + requestItem.getLock() + requestItem.getLockType() + " is related to " + this);
                        if (requestItem.getLock() != this) {
                            System.out.println("Lock: nested lock " + this + " not allowed");
                            throw new PIHscServerException("3203");
                        }
                        if (!(requestItem.getLockType() != 0 && requestItem.getLockType() != 2 || n != 1 && n != 3 && n != 4)) {
                            System.out.println("Lock: New request lock type " + n);
                            throw new PIHscServerException("3203");
                        }
                        requestItem.increaseCount();
                        int n2 = 1;
                        return n2;
                    }
                    requestItem = new RequestItem(thread, this, n);
                }
                int n3 = this.runLock(requestItem, l);
                return n3;
            }
            finally {
                if (debug) {
                    System.out.println(requestQueue.toString());
                }
            }
        }
    }

    private int runLock(RequestItem requestItem, long l) throws PIHscServerException {
        Thread thread = Thread.currentThread();
        RequestQueue requestQueue = RequestQueue.getRequestQueue(this);
        int n = requestItem.getLockType();
        if (requestQueue.canRunNow(requestItem)) {
            requestItem.setStatus(2);
            requestQueue.add(requestItem);
            System.out.println("Lock: Got Lock " + n + " on " + this + " " + thread);
            return 1;
        }
        requestItem.setStatus(0);
        requestQueue.add(requestItem);
        if (n == 2 || n == 3) {
            return 2;
        }
        do {
            try {
                if (l > 0L) {
                    (class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = Lock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue).wait(l);
                    requestQueue.remove(thread, this);
                    throw new PIHscServerException("3202");
                }
                (class$com$ibm$hsc$lock$RequestQueue == null ? Lock.class$("com.ibm.hsc.lock.RequestQueue") : class$com$ibm$hsc$lock$RequestQueue).wait();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("======= I'm awaken. " + thread);
            }
            requestItem = requestQueue.get(thread, this);
            if (requestItem.getStatus() != 1) continue;
            requestItem.setStatus(2);
            System.out.println("Lock: Got Lock " + n + " on " + this + " " + thread);
            return 1;
        } while (requestItem.getStatus() != -1);
        requestQueue.remove(thread, this);
        System.out.println("Lock: Acquiring lock " + n + " on " + this + " failed");
        throw new PIHscServerException("3205");
    }

    public void unlock() throws PIHscServerException {
        Thread thread = Thread.currentThread();
        this.unlock(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Thread thread) throws PIHscServerException {
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = Lock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            RequestQueue requestQueue = RequestQueue.getRequestQueue(this);
            if (debug) {
                System.out.println(requestQueue.toString());
            }
            RequestItem requestItem = requestQueue.get(thread, this);
            if (requestItem == null) {
                System.out.println("Lock: Lock not held " + thread);
                throw new PIHscServerException("3204");
            }
            if (requestItem.getStatus() != 2) {
                System.out.println("Lock: Unlock failed because request was not in running status");
                throw new PIHscServerException("3200");
            }
            requestItem.decreaseCount();
            if (requestItem.getCount() == 0) {
                requestQueue.remove(thread, this);
                System.out.println("Lock: Released Lock on " + this + " " + thread);
                requestQueue.reschedule();
                return;
            }
            System.out.println("Lock: unlock on " + this + " " + thread);
            return;
            finally {
                if (debug) {
                    System.out.println(requestQueue.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPending() throws PIHscServerException {
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = Lock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            Thread thread = Thread.currentThread();
            if (this == NullLock) {
                throw new PIHscServerException("3200");
            }
            RequestQueue requestQueue = RequestQueue.getRequestQueue(this);
            System.out.println("start setPending: " + this);
            if (debug) {
                System.out.println(requestQueue.toString());
            }
            try {
                RequestItem requestItem = requestQueue.get(thread, this);
                if (requestItem == null) {
                    System.out.println("Lock: Lock not held " + thread);
                    throw new PIHscServerException("3204");
                }
                if (requestItem.getStatus() != 2 || requestItem.getLockType() != 1) {
                    System.out.println("Lock: lock not in running or not a write lock.");
                    System.out.println("Lock: lock cannot be set to pending state.");
                    throw new PIHscServerException("3201");
                }
                requestItem.setStatus(3);
                Vector vector = requestQueue.killWaitingWriters(this);
                for (int i = 0; i < vector.size(); ++i) {
                    RequestQueue requestQueue2 = (RequestQueue)vector.elementAt(i);
                    if (debug) {
                        System.out.println("rescheduling request queue: " + requestQueue2.getName() + " after killing waiting writers");
                    }
                    requestQueue2.reschedule();
                }
                Object var9_8 = null;
                System.out.println("end setPending: " + this);
                if (debug) {
                    System.out.println(requestQueue.toString());
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                System.out.println("end setPending: " + this);
                if (debug) {
                    System.out.println(requestQueue.toString());
                }
                throw throwable;
            }
        }
    }

    public int unsetPending() throws PIHscServerException {
        return this.unsetPending(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int unsetPending(long l) throws PIHscServerException {
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = Lock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            Thread thread = Thread.currentThread();
            if (this == NullLock) {
                throw new PIHscServerException("3200");
            }
            RequestQueue requestQueue = RequestQueue.getRequestQueue(this);
            System.out.println("start unsetPending: " + this);
            if (debug) {
                System.out.println(requestQueue.toString());
            }
            try {
                RequestItem requestItem = requestQueue.get(thread, this);
                if (requestItem == null) {
                    System.out.println("Lock: Lock not held " + thread);
                    throw new PIHscServerException("3204");
                }
                if (requestItem.getStatus() != 3 || requestItem.getLockType() != 1) {
                    System.out.println("Lock: lock not in pending or not a write lock.");
                    System.out.println("Lock: lock cannot be unset from pending state.");
                    throw new PIHscServerException("3201");
                }
                requestQueue.remove(thread, this);
                requestItem.setStatus(0);
                int n = this.runLock(requestItem, l);
                Object var9_7 = null;
                System.out.println("end unsetPending: " + this);
                if (!debug) return n;
                System.out.println(requestQueue.toString());
                return n;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                System.out.println("end unsetPending: " + this);
                if (!debug) throw throwable;
                System.out.println(requestQueue.toString());
                throw throwable;
            }
        }
    }

    public void forceUnlockTopRunningRequest() throws PIHscServerException {
        RequestItem requestItem = RequestQueue.getTopRunningRequest(this);
        if (requestItem == null) {
            System.out.println("lock not found: " + this);
            return;
        }
        System.out.println("force releasing Lock: " + requestItem.getLock() + " owned by " + requestItem.getThread());
        requestItem.getLock().unlock(requestItem.getThread());
        System.out.println("force releasing done.");
    }

    public void switchToGroupLock(GroupLock groupLock) throws PIHscServerException {
        groupLock.lockSwitchFrom(this);
    }

    public static void main(String[] stringArray) {
        Lock lock = Lock.getInstance(new String[]{"a", "b", "c"});
        System.out.println("myLock: " + lock);
        Lock lock2 = Lock.getInstance(stringArray);
        System.out.println("the lock: " + lock2);
        if (lock == lock2) {
            System.out.println("aha they are equal");
        }
        System.out.println("isDescendant: " + lock2.isDescendant(lock));
        Lock lock3 = lock2.getParentLock();
        if (lock3 != null) {
            System.out.println("parent: " + lock3);
        } else {
            System.out.println("no parent lock was found ");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            FileReader fileReader = new FileReader("/tmp/.debuglock");
            System.out.println("file /tmp/.debuglock exists");
            debug = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("file /tmp/.debuglock doesn't exist");
            debug = false;
        }
    }
}

